(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 8.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       157,          7]
NotebookDataLength[     34762,       1067]
NotebookOptionsPosition[     30693,        927]
NotebookOutlinePosition[     31489,        954]
CellTagsIndexPosition[     31446,        951]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["Class 04 Coordinate Systems", "Title",
 CellChangeTimes->{{3.5445606379985766`*^9, 3.544560677326826*^9}, {
   3.5446334941030383`*^9, 3.5446334985272913`*^9}, {3.5765962029932547`*^9, 
   3.576596203984667*^9}, 3.576828584940365*^9}],

Cell[CellGroupData[{

Cell["Coordinate Conversions", "Section",
 CellChangeTimes->{{3.544562659400194*^9, 3.5445626844076242`*^9}}],

Cell[TextData[{
 "Both Stewart and ",
 StyleBox["Mathematica ",
  FontSlant->"Italic"],
 "agree about converting to and from cylindrical coordinates ",
 Cell[BoxData[
  FormBox[
   RowBox[{"(", 
    RowBox[{"r", ",", "\[Theta]", ",", "z"}], ")"}], TraditionalForm]],
  FormatType->"TraditionalForm"],
 "."
}], "Text",
 CellChangeTimes->{{3.5446386857782187`*^9, 3.5446386873193073`*^9}, {
  3.5446388207749405`*^9, 3.5446390486299725`*^9}, {3.5446390914694233`*^9, 
  3.544639093987567*^9}, {3.5446391282205253`*^9, 3.544639149327732*^9}, {
  3.5446391921261806`*^9, 3.544639194285304*^9}, {3.5446393015744405`*^9, 
  3.5446393028915157`*^9}, {3.576587142048189*^9, 3.5765871476335907`*^9}, {
  3.589007507906262*^9, 3.589007795523099*^9}, {3.589008187636042*^9, 
  3.589008286313198*^9}, {3.589010120921812*^9, 3.589010164400464*^9}, {
  3.5890463799654217`*^9, 3.589046402348124*^9}, {3.589049629117519*^9, 
  3.58904963078719*^9}}],

Cell[CellGroupData[{

Cell[TextData[{
 "Cylindrical conversions with ",
 StyleBox["CoordinateTransform",
  FontFamily->"Courier New",
  FontWeight->"Bold"]
}], "Subsubsection",
 CellChangeTimes->{{3.5445629191420507`*^9, 3.5445630027498326`*^9}, {
  3.544563081097314*^9, 3.544563090482851*^9}, {3.576595374508213*^9, 
  3.576595374508337*^9}, {3.576597614027317*^9, 3.576597621621327*^9}, {
  3.58904629390952*^9, 3.58904633211031*^9}, {3.5890474161821337`*^9, 
  3.589047451044676*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CoordinateTransform", "[", 
  RowBox[{
   RowBox[{"\"\<Cylindrical\>\"", "\[Rule]", "\"\<Cartesian\>\""}], ",", 
   RowBox[{"{", 
    RowBox[{"r", ",", "\[Theta]", ",", "z"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{
  3.5445630468723564`*^9, {3.576595200776905*^9, 3.5765952289835377`*^9}, 
   3.576595380025627*^9, {3.576595418359084*^9, 3.576595423366523*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"r", " ", 
    RowBox[{"Cos", "[", "\[Theta]", "]"}]}], ",", 
   RowBox[{"r", " ", 
    RowBox[{"Sin", "[", "\[Theta]", "]"}]}], ",", "z"}], "}"}]], "Output",
 CellChangeTimes->{3.5889902950275993`*^9, 3.6081413400674047`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CoordinateTransform", "[", 
  RowBox[{
   RowBox[{"\"\<Cartesian\>\"", "\[Rule]", "\"\<Cylindrical\>\""}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y", ",", "z"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{
  3.5445630468723564`*^9, {3.576595200776905*^9, 3.5765952289835377`*^9}, 
   3.576595380025627*^9, {3.576595418359084*^9, 3.5765954545175457`*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   SqrtBox[
    RowBox[{
     SuperscriptBox["x", "2"], "+", 
     SuperscriptBox["y", "2"]}]], ",", 
   RowBox[{"ArcTan", "[", 
    RowBox[{"x", ",", "y"}], "]"}], ",", "z"}], "}"}]], "Output",
 CellChangeTimes->{3.588990309980135*^9, 3.6081413401679077`*^9}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 "Example 1.  Convert ",
 "cylindrical coordinates",
 " ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"(", 
     RowBox[{"r", ",", "\[Theta]", ",", "z"}], ")"}], "=", 
    RowBox[{"(", 
     RowBox[{"2", ",", 
      FractionBox[
       RowBox[{"3", "\[Pi]"}], "4"], ",", "5"}], ")"}]}], TraditionalForm]]],
 " to rectangular coordinates."
}], "Subsubsection",
 CellChangeTimes->{{3.5445629191420507`*^9, 3.5445630027498326`*^9}, {
  3.544563081097314*^9, 3.544563090482851*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CoordinateTransform", "[", 
  RowBox[{
   RowBox[{"\"\<Cylindrical\>\"", "\[Rule]", "\"\<Cartesian\>\""}], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", 
     FractionBox[
      RowBox[{"3", "\[Pi]"}], "4"], ",", "5"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{
  3.5445630468723564`*^9, {3.576595200776905*^9, 3.5765952289835377`*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", 
    SqrtBox["2"]}], ",", 
   SqrtBox["2"], ",", "5"}], "}"}]], "Output",
 CellChangeTimes->{3.608141340205055*^9}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 "Example 2.  Convert rectangular coordinates ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"(", 
     RowBox[{"x", ",", "y", ",", "z"}], ")"}], "=", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "3"}], 
       SqrtBox["3"]}], ",", 
      RowBox[{"-", "3"}], ",", "5"}], ")"}]}], TraditionalForm]]],
 " to ",
 "cylindrical",
 " coordinates."
}], "Subsubsection",
 CellChangeTimes->{{3.5445631115970583`*^9, 3.544563164438081*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CoordinateTransform", "[", 
  RowBox[{
   RowBox[{"\"\<Cartesian\>\"", "\[Rule]", "\"\<Cylindrical\>\""}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "3"}], 
      SqrtBox["3"]}], ",", 
     RowBox[{"-", "3"}], ",", "5"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.544563179307931*^9, 3.5445631939627695`*^9}, {
  3.5765952410392933`*^9, 3.5765952692398977`*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"6", ",", 
   RowBox[{"-", 
    FractionBox[
     RowBox[{"5", " ", "\[Pi]"}], "6"]}], ",", "5"}], "}"}]], "Output",
 CellChangeTimes->{3.608141340236719*^9}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 "Example 3.  Find an equation of the form ",
 Cell[BoxData[
  FormBox[
   RowBox[{"z", "=", 
    RowBox[{"f", "(", 
     RowBox[{"r", ",", "\[Theta]"}], ")"}]}], TraditionalForm]]],
 " for the surfaces ",
 Cell[BoxData[
  FormBox[Cell[TextData[Cell[BoxData[
    FormBox[
     RowBox[{
      RowBox[{
       SuperscriptBox["x", "2"], "+", 
       SuperscriptBox["y", "2"], "+", 
       SuperscriptBox["z", "2"]}], "=", "9"}], TraditionalForm]]]]], 
   TraditionalForm]]],
 " and ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"x", "+", "y", "+", "z"}], "=", "1"}], TraditionalForm]]],
 "."
}], "Subsubsection",
 CellChangeTimes->{{3.5445638929917517`*^9, 3.544563995176596*^9}}],

Cell[TextData[{
 "Since ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " performs symbolic computation, we can use variable names instead of \
numbers in a coordinate conversion function."
}], "Text",
 CellChangeTimes->{{3.5445640763262377`*^9, 3.5445641209017873`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CoordinateTransform", "[", 
  RowBox[{
   RowBox[{"\"\<Cylindrical\>\"", "\[Rule]", "\"\<Cartesian\>\""}], ",", 
   RowBox[{"{", 
    RowBox[{"r", ",", "\[Theta]", ",", "z"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.544563547993019*^9, 3.5445635848911295`*^9}, {
   3.5765959586629333`*^9, 3.5765959890285063`*^9}, 3.5765960691290503`*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"r", " ", 
    RowBox[{"Cos", "[", "\[Theta]", "]"}]}], ",", 
   RowBox[{"r", " ", 
    RowBox[{"Sin", "[", "\[Theta]", "]"}]}], ",", "z"}], "}"}]], "Output",
 CellChangeTimes->{3.589008559690566*^9, 3.608141340270103*^9}]
}, Open  ]],

Cell[TextData[{
 StyleBox["CoordinateTransform",
  FontFamily->"Courier New",
  FontWeight->"Bold"],
 " is behaving like a function acting on a list and returning a list.  But we \
can turn that into a list of rules instead using ",
 StyleBox["Thread", "Code",
  FontFamily->"Courier New Bold",
  FontWeight->"Plain"],
 "."
}], "Text",
 CellChangeTimes->{{3.5445641437410936`*^9, 3.5445641854524794`*^9}, 
   3.589008568288054*^9, {3.589008782705764*^9, 3.58900880231312*^9}, {
   3.589010230602519*^9, 3.589010417840456*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Thread", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"x", ",", "y", ",", "z"}], "}"}], "->", 
   RowBox[{"CoordinateTransform", "[", 
    RowBox[{
     RowBox[{"\"\<Cylindrical\>\"", "\[Rule]", "\"\<Cartesian\>\""}], ",", 
     RowBox[{"{", 
      RowBox[{"r", ",", "\[Theta]", ",", "z"}], "}"}]}], "]"}]}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.5445638338083663`*^9, 3.544563839022665*^9}, {
  3.576596080470366*^9, 3.576596090445404*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"x", "\[Rule]", 
    RowBox[{"r", " ", 
     RowBox[{"Cos", "[", "\[Theta]", "]"}]}]}], ",", 
   RowBox[{"y", "\[Rule]", 
    RowBox[{"r", " ", 
     RowBox[{"Sin", "[", "\[Theta]", "]"}]}]}], ",", 
   RowBox[{"z", "\[Rule]", "z"}]}], "}"}]], "Output",
 CellChangeTimes->{3.589008572305987*^9, 3.608141340305437*^9}]
}, Open  ]],

Cell[TextData[{
 "We can apply these rules to an equation (or any other expression) with the ",
 StyleBox["/.", "Code",
  FontFamily->"Courier New Bold",
  FontWeight->"Plain"],
 StyleBox[" ",
  FontWeight->"Bold"],
 "substitution operator like this:"
}], "Text",
 CellChangeTimes->{{3.5445643512609634`*^9, 3.544564363235648*^9}, {
  3.589008815768957*^9, 3.5890088720432167`*^9}, {3.589008963580721*^9, 
  3.589008979139806*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"equation", "=", 
  RowBox[{"Simplify", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      SuperscriptBox["x", "2"], "+", 
      SuperscriptBox["y", "2"], "+", 
      SuperscriptBox["z", "2"]}], "==", "9"}], "/.", 
    RowBox[{"Thread", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"x", ",", "y", ",", "z"}], "}"}], "->", 
      RowBox[{"CoordinateTransform", "[", 
       RowBox[{
        RowBox[{"\"\<Cylindrical\>\"", "\[Rule]", "\"\<Cartesian\>\""}], ",", 
        RowBox[{"{", 
         RowBox[{"r", ",", "\[Theta]", ",", "z"}], "}"}]}], "]"}]}], "]"}]}], 
   "]"}]}]], "Input",
 CellChangeTimes->{{3.544563650065857*^9, 3.5445636936993527`*^9}, {
   3.544563844817996*^9, 3.5445638503013096`*^9}, {3.544564289410425*^9, 
   3.544564295758788*^9}, {3.544564369687017*^9, 3.544564378972548*^9}, 
   3.544564459167135*^9, {3.544564498750399*^9, 3.544564499845462*^9}, 
   3.576596105575315*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   SuperscriptBox["r", "2"], "+", 
   SuperscriptBox["z", "2"]}], "\[Equal]", "9"}]], "Output",
 CellChangeTimes->{3.589008585323511*^9, 3.6081413404205627`*^9}]
}, Open  ]],

Cell[TextData[{
 "Now, solve that equation for ",
 Cell[BoxData[
  FormBox["z", TraditionalForm]]],
 " in terms of all the other variables.  (Here ",
 Cell[BoxData[
  FormBox["r", TraditionalForm]],
  FormatType->"TraditionalForm"],
 " is the only variable besides ",
 Cell[BoxData[
  FormBox["z", TraditionalForm]],
  FormatType->"TraditionalForm"],
 "...)"
}], "Text",
 CellChangeTimes->{{3.5445643962365355`*^9, 3.544564422395032*^9}, {
  3.5890105456606417`*^9, 3.589010615477063*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Solve", "[", 
  RowBox[{"equation", ",", "z"}], "]"}]], "Input",
 CellChangeTimes->{{3.544564425792226*^9, 3.5445644481605053`*^9}, {
  3.5445645056237917`*^9, 3.5445645066708517`*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"z", "\[Rule]", 
     RowBox[{"-", 
      SqrtBox[
       RowBox[{"9", "-", 
        SuperscriptBox["r", "2"]}]]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"z", "\[Rule]", 
     SqrtBox[
      RowBox[{"9", "-", 
       SuperscriptBox["r", "2"]}]]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{3.589008613105294*^9, 3.608141340474144*^9}]
}, Open  ]],

Cell[BoxData[""], "Input",
 CellChangeTimes->{{3.5765961128240137`*^9, 3.576596114021228*^9}}],

Cell["\<\
Combine the steps for the other rectangular coordinates equation.\
\>", "Text",
 CellChangeTimes->{{3.5445647070823145`*^9, 3.544564746528571*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Solve", "[", 
  RowBox[{
   RowBox[{"Simplify", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"x", "+", "y", "+", "z"}], "\[Equal]", "1"}], "/.", 
     RowBox[{"Thread", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"x", ",", "y", ",", "z"}], "}"}], "->", 
       RowBox[{"CoordinateTransform", "[", 
        RowBox[{
         RowBox[{"\"\<Cylindrical\>\"", "\[Rule]", "\"\<Cartesian\>\""}], ",", 
         RowBox[{"{", 
          RowBox[{"r", ",", "\[Theta]", ",", "z"}], "}"}]}], "]"}]}], "]"}]}],
     "]"}], ",", "z"}], "]"}]], "Input",
 CellChangeTimes->{{3.5445646211564*^9, 3.5445646787726955`*^9}, 
   3.5765961534073153`*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"z", "\[Rule]", 
    RowBox[{"1", "-", 
     RowBox[{"r", " ", 
      RowBox[{"Cos", "[", "\[Theta]", "]"}]}], "-", 
     RowBox[{"r", " ", 
      RowBox[{"Sin", "[", "\[Theta]", "]"}]}]}]}], "}"}], "}"}]], "Output",
 CellChangeTimes->{3.589009030244628*^9, 3.6081413405785522`*^9}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Spherical coordinates - watch out!\
\>", "Subsubsection",
 CellChangeTimes->{{3.589047486694594*^9, 3.58904749871567*^9}, {
  3.589047826811318*^9, 3.589047835577672*^9}}],

Cell[TextData[{
 "Stewart uses the \[OpenCurlyDoubleQuote]calculus textbook\
\[CloseCurlyDoubleQuote] convention that ",
 Cell[BoxData[
  FormBox[
   RowBox[{"0", "\[LessEqual]", "\[Theta]", "<", 
    RowBox[{"2", "\[Pi]"}]}], TraditionalForm]]],
 " in both cylindrical and spherical coordinates.   For spherical \
coordinates, Stewart uses the order ",
 Cell[BoxData[
  FormBox[
   RowBox[{"(", 
    RowBox[{"\[Rho]", ",", "\[Theta]", ",", "\[Phi]"}], ")"}], 
   TraditionalForm]]],
 ".\nMeanwhile ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " uses the ",
 StyleBox["other",
  FontSlant->"Italic"],
 " convention: spherical coordinates are written in the same order ",
 Cell[BoxData[
  FormBox[
   RowBox[{"(", 
    RowBox[{"\[Rho]", ",", "\[Theta]", ",", "\[Phi]"}], ")"}], 
   TraditionalForm]]],
 " but  \[Theta] is now the polar angle away from the ",
 Cell[BoxData[
  FormBox["z", TraditionalForm]]],
 "-axis, ",
 Cell[BoxData[
  FormBox[
   RowBox[{"0", "\[LessEqual]", "\[Theta]", "<", "\[Pi]"}], TraditionalForm]]],
 ", and \[Phi] is the azimuthal angle ",
 Cell[BoxData[
  FormBox[
   RowBox[{"0", "\[LessEqual]", "\[Phi]", "<", 
    RowBox[{"2", "\[Pi]"}]}], TraditionalForm]]],
 ".\[LineSeparator]\[LineSeparator]The bottom line?  You can use the Stewart \
conventions by swapping order with the ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " functions.  Just make sure that you always interpret:\[LineSeparator]",
 StyleBox["* the second coordinate as Stewart\[CloseCurlyQuote]s ",
  FontColor->RGBColor[1, 0, 0]],
 StyleBox["\[Phi]",
  FontWeight->"Bold",
  FontColor->RGBColor[1, 0, 0]],
 StyleBox[",\n* the third coordinate as Stewart\[CloseCurlyQuote]s ",
  FontColor->RGBColor[1, 0, 0]],
 StyleBox["\[Theta]",
  FontWeight->"Bold",
  FontColor->RGBColor[1, 0, 0]],
 StyleBox[".",
  FontColor->RGBColor[1, 0, 0]]
}], "Text",
 CellChangeTimes->{
  3.5890473963100348`*^9, {3.5890478618954983`*^9, 3.589047892767832*^9}, {
   3.589049671074418*^9, 3.589049754328909*^9}, {3.608146972144692*^9, 
   3.608147068431456*^9}, {3.608147162742552*^9, 3.608147225132968*^9}, {
   3.608147258687295*^9, 3.608147270419948*^9}, {3.608147839592898*^9, 
   3.608147858122013*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CoordinateTransform", "[", 
  RowBox[{
   RowBox[{"\"\<Spherical\>\"", "\[Rule]", "\"\<Cartesian\>\""}], ",", 
   RowBox[{"{", 
    RowBox[{"\[Rho]", ",", "\[Phi]", ",", "\[Theta]"}], "}"}]}], 
  "]"}]], "Input",
 CellChangeTimes->{
  3.5445630468723564`*^9, {3.576595200776905*^9, 3.5765952289835377`*^9}, 
   3.576595380025627*^9, {3.576595418359084*^9, 3.5765954545175457`*^9}, {
   3.576595487709766*^9, 3.576595517439499*^9}, {3.5765955572672977`*^9, 
   3.5765955697228937`*^9}, {3.589007876005582*^9, 3.589007949837188*^9}, {
   3.608147097206604*^9, 3.608147105178846*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"\[Rho]", " ", 
    RowBox[{"Cos", "[", "\[Theta]", "]"}], " ", 
    RowBox[{"Sin", "[", "\[Phi]", "]"}]}], ",", 
   RowBox[{"\[Rho]", " ", 
    RowBox[{"Sin", "[", "\[Theta]", "]"}], " ", 
    RowBox[{"Sin", "[", "\[Phi]", "]"}]}], ",", 
   RowBox[{"\[Rho]", " ", 
    RowBox[{"Cos", "[", "\[Phi]", "]"}]}]}], "}"}]], "Output",
 CellChangeTimes->{{3.589007859739202*^9, 3.589007883508152*^9}, {
   3.589007928712092*^9, 3.589007955802526*^9}, 3.608141340613168*^9, 
   3.608147112438609*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CoordinateTransform", "[", 
  RowBox[{
   RowBox[{"\"\<Cartesian\>\"", "\[Rule]", "\"\<Spherical\>\""}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y", ",", "z"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{
  3.5445630468723564`*^9, {3.576595200776905*^9, 3.5765952289835377`*^9}, 
   3.576595380025627*^9, {3.576595418359084*^9, 3.5765954705325813`*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   SqrtBox[
    RowBox[{
     SuperscriptBox["x", "2"], "+", 
     SuperscriptBox["y", "2"], "+", 
     SuperscriptBox["z", "2"]}]], ",", 
   RowBox[{"ArcTan", "[", 
    RowBox[{"z", ",", 
     SqrtBox[
      RowBox[{
       SuperscriptBox["x", "2"], "+", 
       SuperscriptBox["y", "2"]}]]}], "]"}], ",", 
   RowBox[{"ArcTan", "[", 
    RowBox[{"x", ",", "y"}], "]"}]}], "}"}]], "Output",
 CellChangeTimes->{3.589008304612756*^9, 3.608141340654119*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CoordinateTransform", "[", 
  RowBox[{
   RowBox[{"\"\<Spherical\>\"", "\[Rule]", "\"\<Cylindrical\>\""}], ",", 
   RowBox[{"{", 
    RowBox[{"\[Rho]", ",", "\[Phi]", ",", "\[Theta]"}], "}"}]}], 
  "]"}]], "Input",
 CellChangeTimes->{
  3.5445630468723564`*^9, {3.576595200776905*^9, 3.5765952289835377`*^9}, 
   3.576595380025627*^9, {3.576595418359084*^9, 3.5765954545175457`*^9}, {
   3.576595591571576*^9, 3.5765956005169697`*^9}, {3.5890083321533823`*^9, 
   3.589008341840674*^9}, {3.608147328612371*^9, 3.608147335982134*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"\[Rho]", " ", 
    RowBox[{"Sin", "[", "\[Phi]", "]"}]}], ",", "\[Theta]", ",", 
   RowBox[{"\[Rho]", " ", 
    RowBox[{"Cos", "[", "\[Phi]", "]"}]}]}], "}"}]], "Output",
 CellChangeTimes->{3.589008344886492*^9, 3.608141340688562*^9, 
  3.608147338565175*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CoordinateTransform", "[", 
  RowBox[{
   RowBox[{"\"\<Cylindrical\>\"", "\[Rule]", "\"\<Spherical\>\""}], ",", 
   RowBox[{"{", 
    RowBox[{"r", ",", "\[Theta]", ",", "z"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.576595610675541*^9, 3.5765956309237423`*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   SqrtBox[
    RowBox[{
     SuperscriptBox["r", "2"], "+", 
     SuperscriptBox["z", "2"]}]], ",", 
   RowBox[{"ArcTan", "[", 
    RowBox[{"z", ",", "r"}], "]"}], ",", "\[Theta]"}], "}"}]], "Output",
 CellChangeTimes->{3.589008439165347*^9, 3.6081413407208357`*^9}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Example 4: Convert the Cartesian equation for a spherical surface to \
spherical coordinates.\
\>", "Subsubsection",
 CellChangeTimes->{{3.5890500540092707`*^9, 3.589050103749515*^9}}],

Cell[TextData[{
 "To use Stewart\[CloseCurlyQuote]s convention from within ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ", we could define our own list of rules to convert coordinates according to \
whatever convention we like.  Let\[CloseCurlyQuote]s define our own set of \
rules to convert Cartesian coordinates:"
}], "Text",
 CellChangeTimes->{{3.589009380466888*^9, 3.589009456973328*^9}, {
  3.589009992612486*^9, 3.5890100084447203`*^9}, {3.589010451759817*^9, 
  3.589010468774872*^9}, {3.589050148149413*^9, 3.589050204442092*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StewCartesian2Spherical", "=", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"x", "\[Rule]", 
     RowBox[{"\[Rho]", " ", 
      RowBox[{"Sin", "[", "\[Phi]", "]"}], " ", 
      RowBox[{"Cos", "[", "\[Theta]", "]"}]}]}], ",", 
    RowBox[{"y", "\[Rule]", 
     RowBox[{"\[Rho]", " ", 
      RowBox[{"Sin", "[", "\[Phi]", "]"}], " ", 
      RowBox[{"Sin", "[", "\[Theta]", "]"}]}]}], ",", 
    RowBox[{"z", "\[Rule]", 
     RowBox[{"\[Rho]", " ", 
      RowBox[{"Cos", "[", "\[Phi]", "]"}]}]}]}], "}"}]}]], "Input",
 CellChangeTimes->{{3.5890094705650387`*^9, 3.5890094983263702`*^9}, {
  3.5890095519729767`*^9, 3.589009566539797*^9}, {3.589009648668209*^9, 
  3.589009763432164*^9}, {3.608146078120534*^9, 3.60814608764528*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"x", "\[Rule]", 
    RowBox[{"\[Rho]", " ", 
     RowBox[{"Cos", "[", "\[Theta]", "]"}], " ", 
     RowBox[{"Sin", "[", "\[Phi]", "]"}]}]}], ",", 
   RowBox[{"y", "\[Rule]", 
    RowBox[{"\[Rho]", " ", 
     RowBox[{"Sin", "[", "\[Theta]", "]"}], " ", 
     RowBox[{"Sin", "[", "\[Phi]", "]"}]}]}], ",", 
   RowBox[{"z", "\[Rule]", 
    RowBox[{"\[Rho]", " ", 
     RowBox[{"Cos", "[", "\[Phi]", "]"}]}]}]}], "}"}]], "Output",
 CellChangeTimes->{3.589009765422894*^9, 3.6081413407534*^9, 
  3.6081460902785997`*^9}]
}, Open  ]],

Cell["\<\
Now use this to convert the Cartesian equation for  a sphere of radius 3 to \
spherical coordinates:\
\>", "Text",
 CellChangeTimes->{{3.589009788397954*^9, 3.589009846249892*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"x", "^", "2"}], "+", 
     RowBox[{"y", "^", "2"}], "+", 
     RowBox[{"z", "^", "2"}]}], "\[Equal]", "9"}], " ", "/.", 
   "\[IndentingNewLine]", "StewCartesian2Spherical"}], "\[IndentingNewLine]", 
  "]"}]], "Input",
 CellChangeTimes->{{3.589009849980578*^9, 3.589009912582965*^9}, {
  3.608146096338998*^9, 3.6081461045748367`*^9}}],

Cell[BoxData[
 RowBox[{
  SuperscriptBox["\[Rho]", "2"], "\[Equal]", "9"}]], "Output",
 CellChangeTimes->{3.589009913864313*^9, 3.6081413407867823`*^9, 
  3.608146106810341*^9}]
}, Open  ]],

Cell["...and now solve for \[Rho]:", "Text",
 CellChangeTimes->{{3.5890106914269533`*^9, 3.5890107013520403`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Solve", "[", "%", "]"}]], "Input",
 CellChangeTimes->{{3.589010660101039*^9, 3.589010667260941*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"\[Rho]", "\[Rule]", 
     RowBox[{"-", "3"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\[Rho]", "\[Rule]", "3"}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{3.5890106678106728`*^9, 3.60814134082122*^9}]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
\
\>", "Section",
 CellChangeTimes->{{3.5445772710099306`*^9, 3.5445772763442354`*^9}, {
   3.5445773637762365`*^9, 3.544577377904044*^9}, {3.5445783758651247`*^9, 
   3.544578376289149*^9}, {3.576596193978346*^9, 3.5765961981760902`*^9}, 
   3.5765976799264517`*^9, 3.608142097574361*^9}],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Open  ]],

Cell[CellGroupData[{

Cell["Questions", "Section",
 CellChangeTimes->{{3.5445772710099306`*^9, 3.5445772763442354`*^9}, {
   3.5445773637762365`*^9, 3.544577377904044*^9}, {3.5445783758651247`*^9, 
   3.544578376289149*^9}, {3.576596193978346*^9, 3.5765961981760902`*^9}, 
   3.5765976799264517`*^9, 3.608142097574361*^9}],

Cell["\<\
These questions are based on Sections 9.7 .  Read and use the \
\[OpenCurlyDoubleQuote]Coordinates - Worksheet.nb\[CloseCurlyDoubleQuote] \
file, but write your answers on this page.\
\>", "Text",
 CellChangeTimes->{{3.5441707189185677`*^9, 3.5441707527004995`*^9}, {
   3.5441712929073977`*^9, 3.544171323553151*^9}, {3.5441749813923674`*^9, 
   3.544174987862737*^9}, {3.5443603676606636`*^9, 3.544360377066723*^9}, {
   3.544367441720126*^9, 3.5443675937073345`*^9}, {3.5443680412770195`*^9, 
   3.544368063573019*^9}, {3.544368102255019*^9, 3.544368131837019*^9}, {
   3.544377874216*^9, 3.544377951391*^9}, {3.5444500651598*^9, 
   3.5444500682642*^9}, 3.544453282761227*^9, {3.5445773999063025`*^9, 
   3.5445774196004295`*^9}, {3.5445774787358117`*^9, 3.54457749181556*^9}, {
   3.576587383959551*^9, 3.576587387982485*^9}, {3.576596228568597*^9, 
   3.576596240400485*^9}, 3.576828600301736*^9, {3.608141809340352*^9, 
   3.608141849823352*^9}, {3.6081420121526747`*^9, 3.608142016826783*^9}}],

Cell[CellGroupData[{

Cell["\<\
[3 points] Why are coordinate systems other than the rectangular coordinate \
system used?\[LineSeparator]\[LineSeparator]\[LineSeparator]\
\>", "ItemNumbered",
 CellChangeTimes->{
  3.5441707057218127`*^9, {3.5441707859414015`*^9, 3.544170821116413*^9}, {
   3.544170851205134*^9, 3.54417101548353*^9}, {3.544360394122017*^9, 
   3.544360435660863*^9}, 3.544453282761227*^9, {3.5445774357273517`*^9, 
   3.5445774357333517`*^9}, 3.5445774758726482`*^9, 3.5445775099425964`*^9, {
   3.5445775408703656`*^9, 3.5445775834388003`*^9}, 3.544577827637768*^9, 
   3.5445778619407296`*^9, {3.576597935588916*^9, 3.576597938219137*^9}, {
   3.576828750275298*^9, 3.5768287635477448`*^9}, {3.608142139858045*^9, 
   3.6081421451465282`*^9}, 3.60814222618785*^9, 3.608142342240179*^9}],

Cell[TextData[{
 "[9 points] For the rectangular coordinate system, sketch the level surfaces \
",
 Cell[BoxData[
  FormBox[
   RowBox[{"x", "=", "1"}], TraditionalForm]]],
 ", ",
 Cell[BoxData[
  FormBox[
   RowBox[{"y", "=", "2"}], TraditionalForm]]],
 ", and ",
 Cell[BoxData[
  FormBox[
   RowBox[{"z", "=", 
    RowBox[{"-", "1"}]}], TraditionalForm]]],
 ".  Label the point ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"(", 
     RowBox[{"x", ",", "y", ",", "z"}], ")"}], "=", 
    RowBox[{"(", 
     RowBox[{"1", ",", "2", ",", 
      RowBox[{"-", "1"}]}], ")"}]}], TraditionalForm]]],
 ".\[LineSeparator]\[LineSeparator]\[LineSeparator]\[LineSeparator]\
\[LineSeparator]\[LineSeparator]",
 "\[LineSeparator]\[LineSeparator]\[LineSeparator]\[LineSeparator]"
}], "ItemNumbered",
 CellChangeTimes->{{3.54457760721416*^9, 3.5445777062788267`*^9}, {
  3.576597942002098*^9, 3.576597943402761*^9}, {3.5768287690603323`*^9, 
  3.57682877244387*^9}, {3.608142148300178*^9, 3.6081421537687798`*^9}, {
  3.608142345313236*^9, 3.608142346458107*^9}}],

Cell[TextData[{
 "[9 points] For the cylindrical coordinate system, sketch the level surfaces \
",
 Cell[BoxData[
  FormBox[
   RowBox[{"r", "=", "1"}], TraditionalForm]]],
 ", ",
 Cell[BoxData[
  FormBox[
   RowBox[{"\[Theta]", "=", 
    FractionBox[
     RowBox[{"3", "\[Pi]"}], "4"]}], TraditionalForm]]],
 ", and ",
 Cell[BoxData[
  FormBox[
   RowBox[{"z", "=", "2"}], TraditionalForm]]],
 ".  Label the point ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"(", 
     RowBox[{"r", ",", "\[Theta]", ",", "z"}], ")"}], "=", 
    RowBox[{"(", 
     RowBox[{"1", ",", 
      FractionBox[
       RowBox[{"3", "\[Pi]"}], "4"], ",", "2"}], ")"}]}], TraditionalForm]]],
 ".\[LineSeparator]\[LineSeparator]\[LineSeparator]\[LineSeparator]\
\[LineSeparator]\[LineSeparator]\[LineSeparator]\[LineSeparator]\
\[LineSeparator]\[LineSeparator]\[LineSeparator]"
}], "ItemNumbered",
 CellChangeTimes->{{3.544577715760369*^9, 3.5445778143730087`*^9}, {
  3.544577874319438*^9, 3.544577904867185*^9}, {3.5445782032662525`*^9, 
  3.544578208661561*^9}, {3.57659794642764*^9, 3.5765979478023233`*^9}, {
  3.576828780499647*^9, 3.5768287839794083`*^9}, {3.6081423486822968`*^9, 
  3.60814234899448*^9}}],

Cell[TextData[{
 "[9 points] For the spherical coordinate system, sketch the level surfaces ",
 Cell[BoxData[
  FormBox[
   RowBox[{"\[Rho]", "=", "1"}], TraditionalForm]]],
 ", ",
 Cell[BoxData[
  FormBox[
   RowBox[{"\[Theta]", "=", 
    FractionBox[
     RowBox[{"7", "\[Pi]"}], "4"]}], TraditionalForm]]],
 ", and ",
 Cell[BoxData[
  FormBox[
   RowBox[{"\[Phi]", "=", 
    FractionBox["\[Pi]", "6"]}], TraditionalForm]]],
 ".  Label the point ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"(", 
     RowBox[{"\[Rho]", ",", "\[Theta]", ",", "\[Phi]"}], ")"}], "=", 
    RowBox[{"(", 
     RowBox[{"1", ",", 
      FractionBox[
       RowBox[{"7", "\[Pi]"}], "4"], ",", 
      FractionBox["\[Pi]", "6"]}], ")"}]}], TraditionalForm]]],
 ". (Watch out for Stewart / Mathematic order conflicts!)\[LineSeparator]\
\[LineSeparator]\[LineSeparator]\[LineSeparator]\[LineSeparator]\
\[LineSeparator]\[LineSeparator]\[LineSeparator]\[LineSeparator]\
\[LineSeparator]\[LineSeparator]\[LineSeparator]"
}], "ItemNumbered",
 CellChangeTimes->{{3.5445779053032103`*^9, 3.544577957530197*^9}, {
   3.544578010626234*^9, 3.544578030709383*^9}, {3.544578164632043*^9, 
   3.544578181355999*^9}, {3.544578217451064*^9, 3.544578226743595*^9}, {
   3.5445782774814973`*^9, 3.544578277512499*^9}, {3.5765979504510393`*^9, 
   3.576597952026102*^9}, {3.576828787755574*^9, 3.5768287908831167`*^9}, 
   3.608142165534451*^9, {3.6081423518844337`*^9, 3.608142352228137*^9}, {
   3.608147964063183*^9, 3.608147979566708*^9}}],

Cell["\<\
[9 points] Convert each of the above three points into the other two \
coordinate systems.\[LineSeparator]\[LineSeparator]\[LineSeparator]\
\[LineSeparator]\[LineSeparator]\[LineSeparator]\[LineSeparator]\
\[LineSeparator]\[LineSeparator]\
\>", "ItemNumbered",
 CellChangeTimes->{{3.5445782864170084`*^9, 3.544578305217084*^9}, {
   3.5445784486802893`*^9, 3.54457844868629*^9}, {3.576597955986086*^9, 
   3.576597956989393*^9}, {3.5768287990833693`*^9, 3.576828801699247*^9}, 
   3.608142176666602*^9, {3.608142435709241*^9, 3.608142436117717*^9}}],

Cell[TextData[{
 "[3 points] What surface does the equation ",
 Cell[BoxData[
  FormBox[
   RowBox[{"\[Rho]", "=", 
    RowBox[{"2", "cos", " ", "\[Phi]", " "}]}], TraditionalForm]]],
 " describe?\[LineSeparator]\[LineSeparator]"
}], "ItemNumbered",
 CellChangeTimes->{{3.5445784519044733`*^9, 3.5445784875125103`*^9}, {
  3.5445786470326347`*^9, 3.5445787430321255`*^9}, {3.544578841245743*^9, 
  3.5445789064694734`*^9}, {3.544582448899089*^9, 3.544582483771083*^9}, {
  3.544584203359438*^9, 3.5445843181830053`*^9}, {3.544584366998798*^9, 
  3.5445845477971387`*^9}, {3.544584585209279*^9, 3.5445846794396687`*^9}, {
  3.5445867209944386`*^9, 3.5445868952844076`*^9}, {3.544586951923647*^9, 
  3.544586990411848*^9}, {3.576828642076667*^9, 3.5768286437901278`*^9}, {
  3.576828809619111*^9, 3.5768288115550137`*^9}, {3.6081421976611023`*^9, 
  3.608142202775662*^9}}]
}, Open  ]]
}, Open  ]]
}, Open  ]]
},
WindowSize->{878, 638},
WindowMargins->{{460, Automatic}, {Automatic, 158}},
PrintingCopies->1,
PrintingPageRange->{1, Automatic},
ShowSelection->True,
Magnification:>FEPrivate`If[
  FEPrivate`Equal[FEPrivate`$VersionNumber, 6.], 1.5, 1.5 Inherited],
FrontEndVersion->"9.0 for Mac OS X x86 (32-bit, 64-bit Kernel) (January 25, \
2013)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[StyleDefinitions -> "Default.nb"]], 
   Cell[
    StyleData["ItemNumbered"]]}, Visible -> False, FrontEndVersion -> 
  "9.0 for Mac OS X x86 (32-bit, 64-bit Kernel) (January 25, 2013)", 
  StyleDefinitions -> "PrivateStylesheetFormatting.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[579, 22, 240, 3, 137, "Title"],
Cell[CellGroupData[{
Cell[844, 29, 109, 1, 119, "Section"],
Cell[956, 32, 934, 20, 77, "Text"],
Cell[CellGroupData[{
Cell[1915, 56, 466, 10, 54, "Subsubsection"],
Cell[CellGroupData[{
Cell[2406, 70, 392, 8, 69, "Input"],
Cell[2801, 80, 277, 7, 43, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[3115, 92, 387, 8, 69, "Input"],
Cell[3505, 102, 300, 9, 63, "Output"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[3854, 117, 501, 16, 98, "Subsubsection"],
Cell[CellGroupData[{
Cell[4380, 137, 363, 9, 111, "Input"],
Cell[4746, 148, 171, 6, 52, "Output"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[4966, 160, 475, 17, 96, "Subsubsection"],
Cell[CellGroupData[{
Cell[5466, 181, 419, 11, 100, "Input"],
Cell[5888, 194, 197, 6, 65, "Output"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[6134, 206, 700, 24, 93, "Subsubsection"],
Cell[6837, 232, 276, 7, 76, "Text"],
Cell[CellGroupData[{
Cell[7138, 243, 371, 7, 69, "Input"],
Cell[7512, 252, 273, 7, 43, "Output"]
}, Open  ]],
Cell[7800, 262, 526, 13, 80, "Text"],
Cell[CellGroupData[{
Cell[8351, 279, 470, 12, 94, "Input"],
Cell[8824, 293, 367, 10, 43, "Output"]
}, Open  ]],
Cell[9206, 306, 431, 11, 78, "Text"],
Cell[CellGroupData[{
Cell[9662, 321, 930, 23, 131, "Input"],
Cell[10595, 346, 196, 5, 45, "Output"]
}, Open  ]],
Cell[10806, 354, 489, 15, 78, "Text"],
Cell[CellGroupData[{
Cell[11320, 373, 209, 4, 43, "Input"],
Cell[11532, 379, 413, 14, 64, "Output"]
}, Open  ]],
Cell[11960, 396, 94, 1, 43, "Input"],
Cell[12057, 399, 157, 3, 46, "Text"],
Cell[CellGroupData[{
Cell[12239, 406, 671, 18, 144, "Input"],
Cell[12913, 426, 338, 9, 43, "Output"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[13300, 441, 181, 4, 52, "Subsubsection"],
Cell[13484, 447, 2199, 61, 348, "Text"],
Cell[CellGroupData[{
Cell[15708, 512, 605, 12, 43, "Input"],
Cell[16316, 526, 543, 13, 43, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[16896, 544, 385, 8, 43, "Input"],
Cell[17284, 554, 494, 16, 63, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[17815, 575, 557, 11, 69, "Input"],
Cell[18375, 588, 311, 8, 43, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[18723, 601, 293, 6, 69, "Input"],
Cell[19019, 609, 307, 9, 64, "Output"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[19375, 624, 194, 4, 88, "Subsubsection"],
Cell[19572, 630, 548, 10, 105, "Text"],
Cell[CellGroupData[{
Cell[20145, 644, 748, 17, 69, "Input"],
Cell[20896, 663, 566, 15, 43, "Output"]
}, Open  ]],
Cell[21477, 681, 190, 4, 76, "Text"],
Cell[CellGroupData[{
Cell[21692, 689, 449, 11, 119, "Input"],
Cell[22144, 702, 177, 4, 45, "Output"]
}, Open  ]],
Cell[22336, 709, 114, 1, 46, "Text"],
Cell[CellGroupData[{
Cell[22475, 714, 124, 2, 43, "Input"],
Cell[22602, 718, 279, 8, 43, "Output"]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[22942, 733, 299, 6, 119, "Section"],
Cell[23244, 741, 44, 1, 5, "PageBreak",
 PageBreakBelow->True]
}, Open  ]],
Cell[CellGroupData[{
Cell[23325, 747, 300, 4, 119, "Section"],
Cell[23628, 753, 1011, 15, 76, "Text"],
Cell[CellGroupData[{
Cell[24664, 772, 785, 12, 154, "ItemNumbered"],
Cell[25452, 786, 1055, 31, 378, "ItemNumbered"],
Cell[26510, 819, 1193, 34, 384, "ItemNumbered"],
Cell[27706, 855, 1511, 38, 480, "ItemNumbered"],
Cell[29220, 895, 559, 9, 319, "ItemNumbered"],
Cell[29782, 906, 871, 16, 101, "ItemNumbered"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
